"""Settings model for configurable preferences."""

from typing import Optional
from pydantic import BaseModel, Field


class Settings(BaseModel):
    id: Optional[int] = Field(default=None)
    look_ahead_days: int = Field(default=7, ge=1, description="Days ahead to include in reminders")
    timezone: str = Field(default="Asia/Kolkata")

    class Config:
        orm_mode = True